/*
 * LHARP_PinMap.h
 *
 *  Created on: Feb 3, 2015
 *      Author: Austin Riffle
 */

#ifndef LHARP_PINMAP_H_
#define LHARP_PINMAP_H_

#include "globalDefs.h"

//TODO: This whole file...

// Number of Pins
#define NUM_OF_ADC_PINS							8
#define NUM_OF_LEDS								NUM_OF_ADC_PINS

//LUT types
struct PIN_REGISTER_LUT
{
	const uint8_t pin;
	const uint32_t reg;
};

struct ADC_TO_LED_LUT
{
	const PIN_REGISTER_LUT ledLUT[NUM_OF_LEDS];
	const PIN_REGISTER_LUT adcLUT[NUM_OF_ADC_PINS];
	bool prevState[NUM_OF_ADC_PINS];//bool to remember the previous state of adcValues > threshold
	uint32_t adcValues[NUM_OF_ADC_PINS];
};

#define NUM_MUX_SELECT_LINES 3
#define NUM_MUX_IO_LINES     8

struct MUX_PIN_MAP
{
	const PIN_REGISTER_LUT pinMap[NUM_MUX_SELECT_LINES];
	const uint8_t selectionNumber;
};

#ifdef LAUNCHPAD

//TODO: This should be defined in main.c, bug is currently preventing this. fix.
ADC_TO_LED_LUT adcToLedLUT =
// LED LUT
{{{GPIO_PIN_4, GPIO_PORTC_BASE},  //LED 0
  {GPIO_PIN_5, GPIO_PORTC_BASE},  //LED 1
  {GPIO_PIN_6, GPIO_PORTC_BASE},  //LED 2
  {GPIO_PIN_7, GPIO_PORTC_BASE},  //LED 3
  {GPIO_PIN_2, GPIO_PORTA_BASE},  //LED 4
  {GPIO_PIN_2, GPIO_PORTF_BASE},  //LED 5
  {GPIO_PIN_3, GPIO_PORTF_BASE},  //LED 6
  {GPIO_PIN_4, GPIO_PORTF_BASE},},//LED 7

// ADC LUT
{{GPIO_PIN_2, GPIO_PORTE_BASE},  //AIN 1
 {GPIO_PIN_1, GPIO_PORTE_BASE},  //AIN 2
 {GPIO_PIN_3, GPIO_PORTD_BASE},  //AIN 4
 {GPIO_PIN_2, GPIO_PORTD_BASE},  //AIN 5
 {GPIO_PIN_1, GPIO_PORTD_BASE},  //AIN 6
 {GPIO_PIN_0, GPIO_PORTD_BASE},  //AIN 7
 {GPIO_PIN_5, GPIO_PORTE_BASE},  //AIN 8
 {GPIO_PIN_5, GPIO_PORTB_BASE},},//AIN 11

// Send State values - nothing rx/tx yet
{false, false, false, false, false, false, false, false},

// AIN VALUES
{0,0,0,0,0,0,0,0}};//AIN1,AIN2,AIN4,AIN5,AIN6,AIN7,AIN8,AIN11

const MUX_PIN_MAP muxPinMap[NUM_MUX_IO_LINES] =
{
	// Line 0
	{{{GPIO_PIN_2, GPIO_PORTE_BASE},
	  {GPIO_PIN_1, GPIO_PORTE_BASE},
	  {GPIO_PIN_3, GPIO_PORTD_BASE}}, 0},
	// Line 1
	{{{GPIO_PIN_2, GPIO_PORTE_BASE},
	  {GPIO_PIN_1, GPIO_PORTE_BASE},
	  {GPIO_PIN_3, GPIO_PORTD_BASE}}, 1},
    // Line 2
	{{{GPIO_PIN_2, GPIO_PORTE_BASE},
	  {GPIO_PIN_1, GPIO_PORTE_BASE},
	  {GPIO_PIN_3, GPIO_PORTD_BASE}}, 2},
	// Line 3
	{{{GPIO_PIN_2, GPIO_PORTE_BASE},
	  {GPIO_PIN_1, GPIO_PORTE_BASE},
	  {GPIO_PIN_3, GPIO_PORTD_BASE}}, 3},
	// Line 4
	{{{GPIO_PIN_2, GPIO_PORTE_BASE},
	  {GPIO_PIN_1, GPIO_PORTE_BASE},
	  {GPIO_PIN_3, GPIO_PORTD_BASE}}, 4},
	// Line 5
	{{{GPIO_PIN_2, GPIO_PORTE_BASE},
	  {GPIO_PIN_1, GPIO_PORTE_BASE},
	  {GPIO_PIN_3, GPIO_PORTD_BASE}}, 5},
	// Line 6
	{{{GPIO_PIN_2, GPIO_PORTE_BASE},
	  {GPIO_PIN_1, GPIO_PORTE_BASE},
	  {GPIO_PIN_3, GPIO_PORTD_BASE}}, 6},
	// Line 7
	{{{GPIO_PIN_2, GPIO_PORTE_BASE},
	  {GPIO_PIN_1, GPIO_PORTE_BASE},
	  {GPIO_PIN_3, GPIO_PORTD_BASE}}, 7}
};

#elif CUSTOM_BOARD
//TODO: Set Pin Mappings for Design Board
const MUX_PIN_MAP muxPinMap[NUM_MUX_IO_LINES] =
{
	{{}, 0},
	{{}, 1},
	{{}, 2},
	{{}, 3},
	{{}, 4},
	{{}, 5},
	{{}, 6},
	{{}, 7}
};

#endif

#endif /* LHARP_PINMAP_H_ */
